/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp.internal;

import com.aptana.filesystem.secureftp.SecureUtils;
import com.aptana.filesystem.secureftp.internal.Messages;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SSHHostValidator
extends SSHFTPValidator {
    public SSHHostValidator() {
        block13: {
            String ssh_home = SecureUtils.getSSH_HOME();
            File knownHosts = new File(ssh_home, "known_hosts");
            if (knownHosts.exists() && knownHosts.isFile()) {
                InputStream fin = null;
                try {
                    try {
                        fin = new FileInputStream(knownHosts);
                        this.loadKnownHosts(fin);
                    }
                    catch (Exception e) {
                        SecureFTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.secureftp", Messages.SSHHostValidator_FailedLoadKnownHosts, (Throwable)e));
                        if (fin == null) break block13;
                        try {
                            fin.close();
                        }
                        catch (IOException ignore) {
                            ignore.getCause();
                        }
                    }
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException ignore) {
                            ignore.getCause();
                        }
                    }
                }
            }
        }
    }

    protected boolean validate(String hostSpecifier, SSHFTPPublicKey publicKey, boolean hostKnown) {
        if (!hostKnown) {
            return true;
        }
        return super.validate(hostSpecifier, publicKey, hostKnown);
    }
}

